<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ApiController;
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});
Route::any('category',[ApiController::class,'GetCategory']);
Route::any('products/{id}',[ApiController::class,'GetProducts']);
Route::any('addcategory',[ApiController::class, 'AddCatgory']);
Route::any('addproduct',[ApiController::class, 'AddProduct']);
Route::get('getproduct/{id}',[ApiController::class,'ProductView']);
Route::any('addbooking',[ApiController::class, 'StoreBooking']);
Route::any('booking',[ApiController::class,'BookingView']);
Route::post('register',[ApiController::class,'Register']);
Route::post('login',[ApiController::class,'Login']);
Route::post('productedit',[ApiController::class, 'update']);
Route::get('deleteproduct/{id}',[ApiController::class, 'Delete']);
Route::put('bookingedit/{id}',[ApiController::class, 'bookingupdate']);
Route::delete('deletebooking/{id}',[ApiController::class, 'bookingdestroy']);
Route::get('search', [ApiController::class, 'search']);